"""
Renders README.md
"""

import argparse

from nuplan.database.common.templates import tables
from nuplan.database.common.utils import jsontabledump


def make(version: str) -> None:
    """
    Generate README.md.
    :param version: Database version.
    """
    with open('README.md', 'w') as f:
        f.write('nuPlan DB schema. Version {} \n========== \n'.format(version))
        f.write('`This file is automatically generated so do not edit this file. Stay DRY.`\n\n')

        for table in tables:
            jsontabledump(f, tables[table], table)


if __name__ == '__main__':

    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('version', type=str)
    args = parser.parse_args()

    make(args.version)
